#!/usr/bin/python
# -*- coding: utf-8 -*-
import sys
import time
import json
from resources.lib.api import API
from resources.lib.common import build_url, getInputstreamAddon

import xbmc
import xbmcvfs
import xbmcgui
import xbmcplugin
import xbmcaddon
import inputstreamhelper
import base64

addon_handle = int(sys.argv[1])

class Navigation():
    @staticmethod
    def _getInfoLabel(data):
        info = {}
        info['title'] = data.title
        info['year'] = data.productionYear
        info['plot'] = data.description
        info['country'] = data.productionCountries
        if data.genres != None:
            info['genre'] = data.genres[0]
        info['duration'] = data.duration
        info['episode'] = data.episodeNo
        if data.season == None:
            info['season'] = 1
        else:
            info['season'] = data.season
        return info

    def _setLoginPW(self):
        keyboard = xbmc.Keyboard('', 'Passwort', True)
        keyboard.doModal(60000)
        if (keyboard.isConfirmed() and keyboard.getText() and
            len(keyboard.getText()) >= 6):
            password = keyboard.getText()
            return password
        return ''


    def __init__(self, db):
        self._addon = xbmcaddon.Addon()
        self._db = db
        self._showPremium = False
        self._showlive = False
        self._showLivePay = False
        token = self._addon.getSetting('acc_token')
        refresh_token = self._addon.getSetting('refresh_token')
        lastUpdate = self._addon.getSetting('versionLastUpdate')
        lastUpdateInt = 0
        try:
            if lastUpdate != "":
                lastUpdateInt = float(lastUpdate)
        except:
            pass
        if  lastUpdateInt > time.time() - 60*60*24 :
            clientID = self._addon.getSetting('clientID')
            version = self._addon.getSetting('version')
        else:
            clientID = API.getClientID()
            version = API.getClientVersion()
            self._addon.setSetting('clientID', clientID)
            self._addon.setSetting('version', version)
            self._addon.setSetting('versionLastUpdate', str(time.time()))
        self.api = API(token, refresh_token, clientID=clientID, clientVersion=version)
        if token != self.api.getToken():
            self._addon.setSetting('acc_token', self.api.getToken())
        if refresh_token != self.api.getRefreshToken():
            self._addon.setSetting('refresh_token', self.api.getRefreshToken())
        self._licence_url = ("{licenseURL}|"
            + "User-Agent=Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/118.0"
            + "&x-auth-token={TOKEN}&content-type=text/html&Referer="+base64.b64decode(b'aHR0cHM6Ly9wbHVzLnJ0bC5kZS8=').decode()+"|R{{SSM}}|")
        self._helperActivated = self._addon.getSetting(
            'is_helper_enabled') == "true"
        self._recFile = xbmcvfs.translatePath(self._addon.getAddonInfo('profile')) + "recomendations.json"
        try:
            base64Parts = token.split(".")
            userToken = "%s==" % base64Parts[1]
            userData = json.loads(base64.b64decode(userToken))
            if "permissions" in userData:
                if "streaming" in userData["permissions"]:
                    if "vodAccessToPayContent" in userData["permissions"]["streaming"] and userData["permissions"]["streaming"]["vodAccessToPayContent"]==True:
                        self._showPremium = True
                    if "livestreamAccessToPayTv" in userData["permissions"]["streaming"] and userData["permissions"]["streaming"]["livestreamAccessToPayTv"]==True:
                        self._showLivePay = True
                    if "livestreamAccessToFreeTv" in userData["permissions"]["streaming"] and userData["permissions"]["streaming"]["livestreamAccessToFreeTv"]==True:
                        self._showlive = True
        except:
            pass
        #xbmcplugin.addSortMethod(addon_handle, xbmcplugin.SORT_METHOD_LABEL)

    def login(self):
        keyboard = xbmc.Keyboard('', 'E-Mail-Adresse')
        keyboard.doModal()
        if keyboard.isConfirmed() and keyboard.getText():
            username = keyboard.getText()
            login = self.api.Login(self.api)
            password = self._setLoginPW()
            if password != '':
                if login.sendLogin(username, password):
                    accessToken = login.getAccessToken()
                    self._addon.setSetting('acc_token', accessToken)
                    self._addon.setSetting('refresh_token', login.getRefreshToken())
                    self._addon.setSetting('email', username)
                    xbmcgui.Dialog().notification(
                        'Login erfolgreich', 'Angemeldet als "'
                        + username + '".', icon=xbmcgui.NOTIFICATION_INFO)
                    return True
                else:
                    return False

    def search(self):
        keyboard = xbmc.Keyboard('', 'Suchbegriff')
        keyboard.doModal()
        if keyboard.isConfirmed() and keyboard.getText():
            query = keyboard.getText()
            if query != '':
                self.listSearchResult(query)

    def listLiveTV(self):
        xbmcplugin.setPluginCategory(addon_handle, "LiveTV")
        if self._showPremium:
            for item in self.api.getLive():
                url = build_url({'action': 'playVod', 'id': item.id})
                li = xbmcgui.ListItem(item.title)
                li.setInfo('video', "")
                li.setProperty('IsPlayable', 'true')
                li.setArt({'icon': item.portraitImage})
                xbmcplugin.addDirectoryItem(
                    handle=addon_handle, url=url, listitem=li, isFolder=False)
        xbmcplugin.endOfDirectory(addon_handle, cacheToDisc=False)

    def listEvents(self):
        xbmcplugin.setPluginCategory(addon_handle, "Events")
        if self._showPremium:
            for item in self.api.getEvents():
                url = build_url({'action': 'playVod', 'id': item.id})
                import datetime
                dateTime = datetime.datetime.fromtimestamp(item.startTimestamp)
                title = f"[{dateTime.strftime('%d.%m.%Y %H:%M')}] {item.title}"
                info = {}
                info["title"] = title
                info["plot"] = item.description
                li = xbmcgui.ListItem(title)
                li.setInfo('video', info)
                li.setProperty('IsPlayable', 'true')
                li.setArt({'icon': item.portraitImage})
                xbmcplugin.addDirectoryItem(
                    handle=addon_handle, url=url, listitem=li, isFolder=False)
        xbmcplugin.endOfDirectory(addon_handle, cacheToDisc=False)

    def rootDir(self):
        url = build_url({'action': 'overview', 'id': 'SHOW'})
        li = xbmcgui.ListItem()
        li.setLabel('Shows')
        xbmcplugin.addDirectoryItem(
            handle=addon_handle, url=url, listitem=li, isFolder=True)

        url = build_url({'action': 'overview', 'id': 'SERIES'})
        li = xbmcgui.ListItem()
        li.setLabel('Serien')
        xbmcplugin.addDirectoryItem(
            handle=addon_handle, url=url, listitem=li, isFolder=True)

        url = build_url({'action': 'overview', 'id': 'MOVIE'})
        li = xbmcgui.ListItem()
        li.setLabel('Filme')
        xbmcplugin.addDirectoryItem(
            handle=addon_handle, url=url, listitem=li, isFolder=True)

        url = build_url({'action': 'listLive'})
        li = xbmcgui.ListItem()
        li.setLabel('LiveTV')
        xbmcplugin.addDirectoryItem(
            handle=addon_handle, url=url, listitem=li, isFolder=True)

        url = build_url({'action': 'listEvents'})
        li = xbmcgui.ListItem()
        li.setLabel('Events')
        xbmcplugin.addDirectoryItem(
            handle=addon_handle, url=url, listitem=li, isFolder=True)

        url = build_url({'action': 'recommendation'})
        li = xbmcgui.ListItem()
        li.setLabel('Empfehlungen')
        xbmcplugin.addDirectoryItem(
            handle=addon_handle, url=url, listitem=li, isFolder=True)

        url = build_url({'action': 'search'})
        li = xbmcgui.ListItem()
        li.setLabel('Suche')
        xbmcplugin.addDirectoryItem(
            handle=addon_handle, url=url, listitem=li, isFolder=True)
        xbmcplugin.endOfDirectory(addon_handle, cacheToDisc=False)

    def listEpisodesFromSeason(self, season_id):
        episodes = self.api.getSeason(season_id)
        xbmcplugin.setContent(addon_handle, 'episodes')
        #xbmcplugin.setPluginCategory(
        #   addon_handle, Navigation.buildDirectoryName(data))
        xbmcplugin.addSortMethod(addon_handle, xbmcplugin.SORT_METHOD_EPISODE)

        for ep in episodes:
            if self._showPremium or ep.tier == None or ep.tier == "FREE":
                li = xbmcgui.ListItem()
                li.setProperty('IsPlayable', 'true')
                info = self._getInfoLabel(ep)
                info['mediatype'] = "episode"
                epName = ep.title
                li.setInfo('video', info)
                li.setLabel(epName)
                artDict = {}
                artDict['fanart'] = ep.landscapeImg
                artDict['poster'] = ep.portraitImage
                artDict['icon'] = ep.portraitImage
                li.setArt(artDict)
                url = build_url({'action': 'playVod', 'id': ep.id})
                xbmcplugin.addDirectoryItem(
                        handle=addon_handle, url=url, listitem=li,
                        isFolder=False)
        xbmcplugin.endOfDirectory(addon_handle, cacheToDisc=True)

    def listSearchResult(self, query):
        formats = self.api.search(query)
        for item in formats:
            action = "showMovie" if item.formatType == "Movie" else "listPage"
            url = build_url({'action': action, 'id': item.id})
            li = xbmcgui.ListItem(item.title)
            li.setArt({'icon': item.portraitImage})
            xbmcplugin.addDirectoryItem(
                handle=addon_handle, url=url, listitem=li, isFolder=True)
        xbmcplugin.endOfDirectory(addon_handle, cacheToDisc=True)

    def showMovie(self, movie_id):
        ep = self.api.getMovie(movie_id)
        xbmcplugin.setContent(addon_handle, 'movies')
        if self._showPremium or ep.tier == None or ep.tier == "FREE":
            li = xbmcgui.ListItem()
            li.setProperty('IsPlayable', 'true')
            info = self._getInfoLabel(ep)
            info['mediatype'] = "movie"
            epName = ep.title
            li.setInfo('video', info)
            li.setLabel(epName)
            artDict = {}
            artDict['fanart'] = ep.landscapeImg
            artDict['poster'] = ep.portraitImage
            artDict['icon'] = ep.portraitImage
            li.setArt(artDict)
            url = build_url({'action': 'playVod', 'id': ep.id})
            xbmcplugin.addDirectoryItem(
                    handle=addon_handle, url=url, listitem=li,
                    isFolder=False)
        xbmcplugin.endOfDirectory(addon_handle, cacheToDisc=True)

    def listSeasonsFromSeries(self, formatID):
        format = self.api.getFormat(formatID)
        xbmcplugin.setPluginCategory(addon_handle, format.title)
        posterURL = format.portraitImage
        fanartURL = format.landscapeImg
        xbmcplugin.setContent(addon_handle, 'seasons')
        xbmcplugin.addSortMethod(addon_handle, xbmcplugin.SORT_METHOD_NONE)
        for season in format.seasons:
            url = build_url({'action': 'listSeason', 'season_id': season.id})
            li = xbmcgui.ListItem(label=season.title)
            li.setProperty('IsPlayable', 'false')
            info = {}
            info['title'] = season.title
            info['year'] = season.year
            if season.year != None and season.month != None:
                info['premiered'] = f'{season.year:04d}-{season.month:02d}-01'
                info['dateadded'] = f'{info["premiered"]} 00:00:00'
            li.setInfo('video', info)
            li.setArt({'poster': posterURL, 'icon': posterURL,
                        'fanart': fanartURL})
            xbmcplugin.addDirectoryItem(handle=addon_handle, url=url,
                                        listitem=li, isFolder=True)
        xbmcplugin.endOfDirectory(addon_handle, cacheToDisc=True)

    def listOverview(self, dicttype):
        xbmcplugin.addSortMethod(addon_handle, xbmcplugin.SORT_METHOD_LABEL)
        formats = self.api.getOverview(dicttype)
        action = "showMovie" if dicttype == "MOVIE" else "listPage"
        for item in formats:
            url = build_url({'action': action, 'id': item.id})
            li = xbmcgui.ListItem(item.title)
            li.setArt({'icon': item.portraitImage})
            xbmcplugin.addDirectoryItem(
                handle=addon_handle, url=url, listitem=li, isFolder=True)
        xbmcplugin.endOfDirectory(addon_handle, cacheToDisc=True)

    def playVOD(self, id):
        playBackUrl, licenseURL = self.api.getPlaybackURL(id)
        drmProtected = licenseURL != ""
        if playBackUrl != "":
            li = xbmcgui.ListItem()
            protocol = 'mpd'
            drm = 'com.widevine.alpha'
            # Inputstream settings
            if self._helperActivated and drmProtected:
                is_helper = inputstreamhelper.Helper(protocol, drm=drm)
                if is_helper.check_inputstream():
                    is_addon = is_helper.inputstream_addon
            else:
                is_addon = getInputstreamAddon()
                if not is_addon:
                    xbmcgui.Dialog().notification(
                        'TvNow Fehler', 'Inputstream Addon fehlt!',
                         xbmcgui.NOTIFICATION_ERROR, 2000, True)
                    return
            if drmProtected:
                li.setProperty(is_addon + '.license_type', drm)
                '''if self._patchManifest:
                    playBackUrl = "http://localhost:42467/?id={}&live={}" \
                        .format(assetID, 1 if live == True else 0)'''
            li.setProperty(
                is_addon + '.license_key',
                self._licence_url.format(TOKEN=self.api.getToken(), licenseURL=licenseURL))
            li.setProperty(is_addon + '.manifest_type', protocol)
            '''if live:
                li.setProperty(
                    is_addon + '.manifest_update_parameter',  "full")'''
            li.setProperty('inputstream', is_addon)
            li.setPath(playBackUrl)
            # Start Playing
            xbmcplugin.setResolvedUrl(addon_handle, True, listitem=li)
        else:
            xbmcgui.Dialog().notification(
                'Abspielen fehlgeschlagen',
                'Es ist keine Abspiel URL vorhanden',
                icon=xbmcgui.NOTIFICATION_ERROR)

    def recommendationOverview(self):
        formats = self.api.getRecommendationOverview(cacheFile=self._recFile)
        for item in formats:
            url = build_url({'action': "listRecommendation", 'id': item.id})
            li = xbmcgui.ListItem(item.title)
            xbmcplugin.addDirectoryItem(
                handle=addon_handle, url=url, listitem=li, isFolder=True)
        xbmcplugin.endOfDirectory(addon_handle, cacheToDisc=True)

    def listRecommendation(self, recId):
        formats = self.api.getRecommendation(recId, self._recFile)
        for item in formats:
            action = "showMovie" if item.formatType == "Movie" else "listPage"
            url = build_url({'action': action, 'id': item.id})
            li = xbmcgui.ListItem(item.title)
            li.setArt({'icon': item.portraitImage})
            xbmcplugin.addDirectoryItem(
                handle=addon_handle, url=url, listitem=li, isFolder=True)
        xbmcplugin.endOfDirectory(addon_handle, cacheToDisc=True)

    def logout(self):
        self._addon.setSetting('acc_token', "")
        self._addon.setSetting('refresh_token',"")
        self._addon.setSetting('email', "")
        self._addon.setSetting('premium',"false")
        self._addon.setSetting('liveFree', "false")
        self._addon.setSetting('livePay', "false")